%------------------------------------------------------------------------------
% File     : NUM712^1 : TPTP v9.2.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 31
% Version  : Especial.
% English  : ts (ts x y) z = ts x (ts y z)

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz31 [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 0.78 v9.1.0, 0.75 v9.0.0, 0.80 v8.2.0, 0.92 v8.1.0, 0.91 v7.5.0, 1.00 v3.7.0
% Syntax   : Number of formulae    :   20 (   8 unt;  11 typ;   0 def)
%            Number of atoms       :   12 (   6 equ;   0 cnn)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   58 (   0   ~;   0   |;   0   &;  53   @)
%                                         (   0 <=>;   5  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   11 (  11   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   10 (   9 usr;   4 con; 0-2 aty)
%            Number of variables   :   16 (   0   ^;  16   !;   0   ?;  16   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nat_type,type,
    nat: $tType ).

thf(x,type,
    x: nat ).

thf(y,type,
    y: nat ).

thf(z,type,
    z: nat ).

thf(ts,type,
    ts: nat > nat > nat ).

thf(set_type,type,
    set: $tType ).

thf(esti,type,
    esti: nat > set > $o ).

thf(setof,type,
    setof: ( nat > $o ) > set ).

thf(estie,axiom,
    ! [Xp: nat > $o,Xs: nat] :
      ( ( esti @ Xs @ ( setof @ Xp ) )
     => ( Xp @ Xs ) ) ).

thf(n_1,type,
    n_1: nat ).

thf(suc,type,
    suc: nat > nat ).

thf(ax5,axiom,
    ! [Xs: set] :
      ( ( esti @ n_1 @ Xs )
     => ( ! [Xx: nat] :
            ( ( esti @ Xx @ Xs )
           => ( esti @ ( suc @ Xx ) @ Xs ) )
       => ! [Xx: nat] : ( esti @ Xx @ Xs ) ) ) ).

thf(estii,axiom,
    ! [Xp: nat > $o,Xs: nat] :
      ( ( Xp @ Xs )
     => ( esti @ Xs @ ( setof @ Xp ) ) ) ).

thf(satz28e,axiom,
    ! [Xx: nat] :
      ( Xx
      = ( ts @ Xx @ n_1 ) ) ).

thf(satz28a,axiom,
    ! [Xx: nat] :
      ( ( ts @ Xx @ n_1 )
      = Xx ) ).

thf(pl,type,
    pl: nat > nat > nat ).

thf(satz28f,axiom,
    ! [Xx: nat,Xy: nat] :
      ( ( pl @ ( ts @ Xx @ Xy ) @ Xx )
      = ( ts @ Xx @ ( suc @ Xy ) ) ) ).

thf(satz30,axiom,
    ! [Xx: nat,Xy: nat,Xz: nat] :
      ( ( ts @ Xx @ ( pl @ Xy @ Xz ) )
      = ( pl @ ( ts @ Xx @ Xy ) @ ( ts @ Xx @ Xz ) ) ) ).

thf(satz28b,axiom,
    ! [Xx: nat,Xy: nat] :
      ( ( ts @ Xx @ ( suc @ Xy ) )
      = ( pl @ ( ts @ Xx @ Xy ) @ Xx ) ) ).

thf(satz31,conjecture,
    ( ( ts @ ( ts @ x @ y ) @ z )
    = ( ts @ x @ ( ts @ y @ z ) ) ) ).

%------------------------------------------------------------------------------
